% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ps.R
\name{predict.PSmodel}
\alias{predict.PSmodel}
\title{Predict Method for Pruned Set Transformation}
\usage{
\method{predict}{PSmodel}(object, newdata,
  probability = getOption("utiml.use.probs", TRUE), ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed", NA))
}
\arguments{
\item{object}{Object of class '\code{PSmodel}'.}

\item{newdata}{An object containing the new input data. This must be a
matrix, data.frame or a mldr object.}

\item{probability}{Logical indicating whether class probabilities should be
returned. (Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{...}{Others arguments passed to the base algorithm prediction for all
subproblems.}

\item{cores}{Not used}

\item{seed}{An optional integer used to set the seed. (Default:
\code{options("utiml.seed", NA)})}
}
\value{
An object of type mlresult, based on the parameter probability.
}
\description{
This function predicts values based upon a model trained by
 \code{\link{ps}}.
}
\examples{
model <- ps(toyml, "RANDOM")
pred <- predict(model, toyml)
}
\seealso{
\code{\link[=ps]{Pruned Set (PS)}}
}
