% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_baseline.R
\name{predict.BASELINEmodel}
\alias{predict.BASELINEmodel}
\title{Predict Method for BASELINE}
\usage{
\method{predict}{BASELINEmodel}(object, newdata,
  probability = getOption("utiml.use.probs", TRUE), ...)
}
\arguments{
\item{object}{Object of class '\code{BASELINEmodel}'.}

\item{newdata}{An object containing the new input data. This must be a
matrix, data.frame or a mldr object.}

\item{probability}{Logical indicating whether class probabilities should be
returned. (Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{...}{not used.}
}
\value{
An object of type mlresult, based on the parameter probability.
}
\description{
This function predicts values based upon a model trained by
\code{\link{baseline}}.
}
\examples{
model <- baseline(toyml)
pred <- predict(model, toyml)
}
\seealso{
\code{\link[=baseline]{Baseline}}
}
