% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{paste_efs}
\alias{paste_efs}
\title{paste_efs}
\usage{
paste_efs(fit = NULL, time = NULL, percent.sign = TRUE, digits = 1)
}
\arguments{
\item{fit}{Required. survival::Surv() object. The time-to-event model of interest.}

\item{time}{Required. Numeric. Indicates duration of time. Units are whatever was used to
create the time-to-event model.}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round to. Defaults to 1.}
}
\description{
Returns a human-readable event-free-survival from a survfit object
and a specified time point.
}
\examples{
library(survival)
fit <- survfit(Surv(time, status) ~ 1, data = diabetic)
paste_efs(fit, 6)
}
