% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_processing.R
\name{plot_pairs}
\alias{plot_pairs}
\title{Plot pairwise parameter distributions}
\usage{
plot_pairs(model_output, type = "biphasic", textsize = 9,
  pointsize = 1, linesize = 0.5)
}
\arguments{
\item{model_output}{output from model fitting using ushr().}

\item{type}{character string indicating whether the biphasic or single phase fits should be plotted. Must be either "biphasic", "single", or "triphasic". Defaults to "biphasic".}

\item{textsize}{numeric value for base text size. Default is 9.}

\item{pointsize}{numeric value for point size. Default is 1.}

\item{linesize}{numeric value for line width; only used for GGally plots. Default is 0.5.}
}
\description{
This function creates pairwise scatterplots of the estimates parameters. The default plotting method requires GGally; if this packge is not available, base R is used instead.
}
\examples{

set.seed(1234567)

simulated_data <- simulate_data(nsubjects = 20)

model_output <- ushr(data = simulated_data)

plot_pairs(model_output)
}
