% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code-of-conduct.R
\name{use_code_of_conduct}
\alias{use_code_of_conduct}
\title{Add a code of conduct}
\usage{
use_code_of_conduct(path = NULL)
}
\arguments{
\item{path}{Path of the directory to put \code{CODE_OF_CONDUCT.md} in, relative to
the active project. Passed along to \code{\link[=use_directory]{use_directory()}}. Default is to locate
at top-level, but \verb{.github/} is also common.}
}
\description{
Adds a \code{CODE_OF_CONDUCT.md} file to the active project and lists in
\code{.Rbuildignore}, in the case of a package. The goal of a code of conduct is
to foster an environment of inclusiveness, and to explicitly discourage
inappropriate behaviour. The template comes from
\url{https://www.contributor-covenant.org}, version 2:
\url{https://www.contributor-covenant.org/version/2/0/code_of_conduct/}.
}
\details{
If your package is going to CRAN, the link to the CoC in your README must
be an absolute link to a rendered website as \code{CODE_OF_CONDUCT.md} is not
included in the package sent to CRAN. \code{use_code_of_conduct()} will
automatically generate this link if you use pkgdown and have set the
\code{url} field in \code{pkgdown.yml}; otherwise it'll link to
\url{https://www.contributor-covenant.org/version/2/0/code_of_conduct/}.
}
