% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ColumnReorder.r
\name{colsToFront}
\alias{colsToFront}
\alias{colsToBack}
\title{colsToFront}
\usage{
colsToFront(data, cols = names(data))

colsToBack(data, cols = names(data))
}
\arguments{
\item{data}{data.frame or tbl}

\item{cols}{Columns that should be moved}
}
\value{
Character vector of column names
}
\description{
Moves column names to the front or back of the names
}
\details{
Moves column names to the front or back of the names
}
\examples{
theDF <- data.frame(A=1:10, B=11:20, C=1:10, D=11:20)
colsToFront(theDF, c('B', 'C'))
colsToFront(theDF, c('C', 'B'))
colsToFront(theDF, c('C', 'C'))
colsToBack(theDF, c('C', 'C'))
colsToBack(theDF, c('C', 'B'))
colsToBack(theDF, c('C', 'C'))

}
\author{
Jared P. Lander
}
