% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeansPlotting.r
\name{fortify.kmeans}
\alias{fortify.kmeans}
\title{fortify.kmeans}
\usage{
\method{fortify}{kmeans}(model, data = NULL, ...)
}
\arguments{
\item{model}{\code{\link{kmeans}} model}

\item{data}{Data used to fit the model}

\item{\dots}{Not Used}
}
\value{
The original data with extra columns:
     \item{.x}{The projected x position.}
     \item{.y}{The projected y position.}
     \item{.Cluster}{The cluster that point belongs to.}
}
\description{
Fortify a kmeans model with its data
}
\details{
Prepares a kmeans object to be plotted using \code{\link{cmdscale}} to compute the projected x/y coordinates.  If \code{data} is not provided, then just the center points are calculated.
}
\examples{

k1 <- kmeans(x=iris[, 1:4], centers=3)
hold <- fortify(k1, data=iris)
head(hold)
hold2 <- fortify(k1)
head(hold2)

}
\author{
Jared P. Lander
}
\seealso{
kmeans fortify ggplot plot.kmeans
}

