% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_LinksLookup}
\alias{bitly_LinksLookup}
\title{Query for a Bitlink based on a long URL.}
\usage{
bitly_LinksLookup(url, showRequestURL = FALSE)
}
\arguments{
\item{url}{- one long URLs to lookup.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug 
purposes.}
}
\value{
url - an echo back of the url parameter.

aggregate_link - the corresponding bitly aggregate link (global hash).
}
\description{
See \url{http://dev.bitly.com/links.html#v3_link_lookup}
}
\examples{
\dontrun{ 
bitly_token <- bitly_auth(key = "be03aead58f23bc1aee6e1d7b7a1d99d62f0ede8", 
secret = "b7e4abaf8b26ec4daa92b1e64502736f5cd78899")
bitly_LinksLookup(url = "http://www.seznam.cz/")
bitly_LinksLookup(url = "http://www.seznam.cz/", showRequestURL = TRUE) 

manyUrls <- list("http://www.seznam.cz/", "http://www.seznamasdas.cz/", 
"http://www.seznam.cz/asadasd", "http://www.seznam.cz/adqwrewtregt")
for (u in 1:length(manyUrls)) {
   print(bitly_LinksLookup(url = manyUrls[[u]], showRequestURL = TRUE))
}
}

}

