% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{url_build}
\alias{url_build}
\title{Builds a URL string from its components.}
\usage{
url_build(url_components)
}
\arguments{
\item{url_components}{A list containing the components of the URL: scheme, host, port, path, query, and fragment.
\itemize{
\item \strong{scheme} A character string for the new scheme (e.g., "http" or "https") or \code{NULL} to keep it unchanged.
\item \strong{host} A character string for the new host or \code{NULL} to keep it unchanged.
\item \strong{port} A character string for the new port or \code{NULL} to keep it unchanged.
\item \strong{path} A character string for the new path or \code{NULL} to keep it unchanged.
\item \strong{query} A list or character of new query parameters or \code{NULL} to keep it unchanged.
\item \strong{fragment} A character string for the new fragment or \code{NULL} to keep it unchanged.
}}
}
\value{
A URL string constructed from the provided components
}
\description{
Builds a URL string from its components.
}
\examples{
library(urlparse)
url_build(list(
  scheme = "https",
  user = "",
  password = "",
  host = "host.com",
  port = 8000,
  path = "/path",
  query = "query",
  fragment = "fragment"
))

}
