% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plUpliftEval.R
\name{pl_plot}
\alias{pl_plot}
\title{A port of pylift's plot function (https://github.com/wayfair/pylift) as of commit:
https://github.com/wayfair/pylift/tree/bb69692388b1fe085001c3ba7edf6dd81d888353
pylift: Plots the different kinds of percentage-targeted curves.}
\usage{
pl_plot(plue, plot_type = "cgains", n_bins = 20,
  show_theoretical_max = FALSE, show_practical_max = FALSE,
  show_random_selection = TRUE, show_no_dogs = FALSE, ...)
}
\arguments{
\item{plue}{the result of a call to the plUpliftEval constructor}

\item{plot_type}{string, optional Either 'qini', 'aqini', 'uplift', 'cuplift', or 'balance'.
'aqini' refers to an adjusted qini plot, 'cuplift' gives a
cumulative uplift plot. 'balance' gives the test-control balance
for each of the bins. All others are self-explanatory.}

\item{n_bins}{integer, number of population bins; default 20}

\item{show_theoretical_max}{boolean, optional
Toggle theoretical maximal qini curve, if overfitting to
treatment/control. Only works for Qini-style curves.}

\item{show_practical_max}{boolean, optional
Toggle theoretical maximal qini curve, if not overfitting to
treatment/control. Only works for Qini-style curves.}

\item{show_random_selection}{boolean, optional
Toggle straight line indicating a random ordering. Only works for
Qini-style curves.}

\item{show_no_dogs}{boolean, optional
Toggle theoretical maximal qini curve, if you believe there are no
sleeping dogs. Only works for Qini-style curves.}

\item{...}{additional arguments}
}
\value{
a pylift plot
}
\description{
A port of pylift's plot function (https://github.com/wayfair/pylift) as of commit:
https://github.com/wayfair/pylift/tree/bb69692388b1fe085001c3ba7edf6dd81d888353
pylift: Plots the different kinds of percentage-targeted curves.
}
\examples{

set.seed(0)
rl <- function(x){
  round(1/(1+exp(-x)))
}
n <- 2000; p <- 3
beta <- -0.5
X <- matrix(rnorm(n*p), n, p)
W <- rbinom(n, 1, 0.5)
Y <- rl(pmax(beta+X[,1], 0) * W + X[,2])
p1 <- 1/(1+exp(-(beta+X[,1])))
plue <- plUpliftEval(W, Y, p1)
pl_plot(plue,
        show_practical_max = TRUE,
        show_theoretical_max = TRUE,
        show_no_dogs = TRUE,
        n_bins=20)

\donttest{
library(grf)
set.seed(123)

rl <- function(x){
  round(1/(1+exp(-x)))
}
n <- 2000; p <- 10
X <- matrix(rnorm(n*p), n, p)
W <- rbinom(n, 1, 0.2)
Y <- rl(rl(X[,1]) * W - rl(X[,3]) * W + rnorm(n))
tau.forest <- causal_forest(X, Y, W)
tau.hat <- predict(tau.forest, X)
plue <- plUpliftEval(W, Y, tau.hat$predictions)
plue
pl_plot(plue,
        show_practical_max = TRUE,
        show_theoretical_max = TRUE,
        show_no_dogs = TRUE,
        n_bins=20)
}

}
