% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolate_sentinels.R
\name{isolate_sentinels}
\alias{isolate_sentinels}
\title{Move sentinel values into a separate column leaving NA behind}
\usage{
isolate_sentinels(.data, col, sentinels, into = "sentinel")
}
\arguments{
\item{.data}{A data frame.}

\item{col}{The name of the column of data containing sentinel values.}

\item{sentinels}{A vector of sentinel values to be removed.}

\item{into}{A name to give the new column of sentinel values.}
}
\description{
A sentinel value, takes the place of a value that isn't
available for some reason.  \code{\link[=isolate_sentinels]{isolate_sentinels()}} removes these values from a
column of data into a separate column, and optionally converts the data left
behind into an appropriate data type.
}
\examples{
x <- data.frame(name = c("Matilda", "Nicholas", "Olivia", "Paul"),
                score = c(10, "confidential", "N/A", 12),
                stringsAsFactors = FALSE)
x
isolate_sentinels(x, score, c("confidential", "N/A"))
isolate_sentinels(x, score, c("confidential", "N/A"), "flag")
}
