% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_def_1.R
\docType{data}
\name{Signal}
\alias{Signal}
\title{uni.kn color Signal or alert.}
\format{An object of class \code{character} of length 1.}
\usage{
Signal
}
\description{
\code{Signal} provides the alert color of \code{\link{pal_signal}} 
(as an atomic HEX character value) and is defined as 
\code{\link{pal_signal}[2]}.
}
\details{
The official specification of \code{\link{pal_signal}} 
does not identify a preferred color. 
We provide \code{Signal} as a dedicated color 
as it is suited for creating color gradients 
(see \code{\link{usecol}}). 
 
See \url{https://www.uni-konstanz.de} for details.
}
\examples{
Signal  # HEX character "#EFDC60" (as value)
all.equal(Signal, pal_signal[[2]])  # TRUE (same HEX values)

}
\seealso{
\code{\link{pal_unikn}} for the unikn default color palette with all 5 colors of \code{\link{pal_seeblau}}; 
\code{\link{pal_signal}} for the corresponding color palette; 
\code{\link{pal_unikn_pref}} for a uni.kn color palette with all preferred colors; 
\code{\link{seecol}} to show color palettes;
\code{\link{usecol}} to use color palettes.

Other preferred colors: \code{\link{Bordeaux}},
  \code{\link{Grau}}, \code{\link{Karpfenblau}},
  \code{\link{Peach}}, \code{\link{Petrol}},
  \code{\link{Pinky}}, \code{\link{Seeblau}},
  \code{\link{Seegruen}}
}
\concept{preferred colors}
\keyword{datasets}
