% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unigd.R
\name{ugd_close}
\alias{ugd_close}
\title{Close unigd device.}
\usage{
ugd_close(which = dev.cur(), all = FALSE)
}
\arguments{
\item{which}{Which device (ID).}

\item{all}{Should all running unigd devices be closed.}
}
\value{
Number and name of the new active device (after the specified device
has been shut down).
}
\description{
This achieves the same effect as \code{\link[grDevices:dev]{grDevices::dev.off()}},
but will only close the device if it has the unigd type.
}
\examples{
ugd()
hist(rnorm(100))
ugd_close() # Equvalent to dev.off()

ugd()
ugd()
ugd()
ugd_close(all = TRUE)
}
