% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex.R
\name{runif_in_simplex}
\alias{runif_in_simplex}
\title{Uniform sampling in a simplex}
\usage{
runif_in_simplex(n, simplex)
}
\arguments{
\item{n}{number of simulations}

\item{simplex}{a \code{(d+1)} times \code{d} matrix giving the vertices of
the simplex (rows)}
}
\value{
The simulations in a \code{n} times \code{d} matrix.
}
\description{
Uniform sampling in a simplex (arbitrary dimension).
}
\note{
In dimension 3, you can use \code{\link{runif_in_tetrahedron}} instead.
}
\examples{
simplex <- rbind(c(0,0,0), c(1,0,0), c(1,1,0), c(1,1,2))
sims <- runif_in_simplex(1000, simplex)
\donttest{library(rgl)
points3d(sims)}
}
