% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oslo.R
\docType{data}
\name{oslo}
\alias{oslo}
\title{Colours of the University of Oslo, Norway}
\format{
An object of class \code{character} of length 16.
}
\source{
Color definitions are based on \href{https://www.uio.no}{UiO}'s 
\href{https://www.uio.no/english/about/designmanual/profile-elements/colour-palette/}{design manual} (HTML).
}
\usage{
oslo
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{oslo} provides the colours 
of the \href{https://www.uio.no}{University of Oslo}, Norway.
}
\details{
\code{oslo} is based on HEX color definitions.


See \href{https://www.uio.no}{UiO}'s 
\href{https://www.uio.no/english/about/designmanual/profile-elements/colour-palette/}{design manual} 
for usage, inspirations, and alternative definitions.
}
\examples{
oslo
unikn::seecol(oslo, main = "The colours of the University of Oslo, Norway") # view palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Norwegian university color palettes: 
\code{\link{bergen_1}},
\code{\link{bergen_2}},
\code{\link{bergen_3}},
\code{\link{bergen_4}}
}
\author{
\strong{unicol}, 2023-10-10.
}
\concept{Norwegian university color palettes}
\keyword{datasets}
