% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Guelph.R
\docType{data}
\name{guelph}
\alias{guelph}
\title{Colours of the University of Guelph, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on \href{https://www.uoguelph.ca}{U of G}'s 
\href{https://news.uoguelph.ca/guides/brand-guide/colour-palette/}{brand guide} (HTML).
}
\usage{
guelph
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{guelph} provides the two primary colours and the two secondary colors
of the \href{https://www.uoguelph.ca}{University of Guelph}, Canada.
}
\details{
The 2 primary colours are 
\code{"PMS 200"} (defined as RGB 194 4 48, CMYK 0 100 65 15,or HEX #C20430) and
\code{"black"} (defined as RGB 0 0 0, CMYK 0 0 0 100, or HEX #000000).

The 2 secondary colours are
\code{"PMS 123"} (defined as RGB 255 199 42, CMYK 0 30 95 0, or HEX #FFC72A) and
\code{"PMS 549"} (defined as RGB 105 163 185, CMYK 52 6 0 25, or HEX ##69A3B9).

\code{guelph} uses the HEX color definitions. 

See \href{https://news.uoguelph.ca/guides/brand-guide/colour-palette/}{Brand guide: Colour} 
for \emph{Do's and Don'ts} and \emph{Colour Usage and Proportions}.
}
\examples{
guelph
unikn::seecol(guelph, main = "Colours of the University of Guelph, CA")  # view palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-07-12.
}
\concept{Canadian university color palettes}
\keyword{datasets}
