% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UWaterloo.R
\docType{data}
\name{uwaterloo_engineering}
\alias{uwaterloo_engineering}
\title{Faculty of Engineering colors of the University of Waterloo, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the University of Waterloo's 
\href{https://uwaterloo.ca/brand/}{Brand home}.
}
\usage{
uwaterloo_engineering
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uwaterloo_engineering} provides the four purple color levels
of the \href{https://uwaterloo.ca}{University of Waterloo}, Canada.
}
\details{
Use the colour Purple to identify content and communications from the Faculty of Engineering.

The 4 purple colors are 
\code{"Purple Level 1"} (defined as CMYK: 27 28 0 0, RGB: 208 180 239, HEX: #D0B4E7),
\code{"Purple Level 2"} (defined as CMYK: 51 71 0 0, RGB: 190 51 218, HEX: #BE33DA),
\code{"Purple Level 3"} (print primary color) (defined as CMYK: 60 72 0 0, RGB: 129 0 180, HEX:	#8100B4), and
\code{"Purple Level 4"} (digital primary color) (defined as CMYK: 78 94 0 0, RGB: 87 5 139, HEX: #57058B).

\code{uwaterloo_engineering} uses the HEX color definitions.
}
\examples{
uwaterloo_engineering
unikn::seecol(uwaterloo_engineering, main = "Engineering faculty colors of UWaterloo") 
# view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-29.
}
\concept{Canadian university color palettes}
\keyword{datasets}
