% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oxford.R
\docType{data}
\name{oxford_graduate}
\alias{oxford_graduate}
\title{Graduate country page colours of University of Oxford, England, UK}
\format{
An object of class \code{character} of length 12.
}
\source{
Colour definitions are based on 
\href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Oxford's digital style guide}.
}
\usage{
oxford_graduate
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{oxford_graduate} provides the twelve graduate country page colours 
of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
}
\details{
The 23 graduate country page colours are
\code{"graduate_light_blue"} (defined as HEX #9eceeb),
\code{"graduate_blue"} (defined as HEX #5f9baf),
\code{"graduate_navy_blue"} (defined as HEX #44687d),
\code{"graduate_grey_blue"} (defined as HEX #a1c4d0),
\code{"graduate_dark_green"} (defined as HEX #69913b),
\code{"graduate_light_green"} (defined as HEX #aab300),
\code{"graduate_orange"} (defined as HEX #cf7a30),
\code{"graduate_yellow"} (defined as HEX #f5cf47),
\code{"graduate_dark_red"} (defined as HEX #872434),
\code{"graduate_red"} (defined as HEX #be0f34),
\code{"graduate_pink"} (defined as HEX #ebc4cb), and
\code{"graduate_grey"} (defined as HEX #a79d96).
}
\examples{
oxford_graduate
unikn::seecol(oxford_graduate, 
              main = "Uni Oxford graduate country page colours") # view colour palette

}
\seealso{
\code{\link{oxford_brand}} for the brand colours of University of Oxford;
\code{\link{oxford_general}} for the general colours of University of Oxford;
\code{\link{oxford_link}} for the link colours of University of Oxford;
\code{\link{oxford_shades}} for the shade colours of University of Oxford;
\code{\link{oxford_blog}} for the blog colours of University of Oxford;
\code{\link{oxford_error}} for the error colours of University of Oxford;
\code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-15.
}
\concept{English university color palettes}
\keyword{datasets}
