% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nottingham.R
\docType{data}
\name{nottingham_1}
\alias{nottingham_1}
\title{Primary colours of the University of Nottingham, England/UK}
\format{
An object of class \code{character} of length 6.
}
\source{
Colour definitions are based on the UoN's 
\href{https://www.nottingham.ac.uk/brand/visual/colour.aspx}{Colour guidelines}.
}
\usage{
nottingham_1
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{nottingham_1} provides the primary colour and five corresponding tints   
of the \href{https://www.nottingham.ac.uk}{University of Nottingham}, England/UK.
}
\details{
\code{Nottingham blue} is the key colour for the university 
and should feature on all assets. 
It is defined as \code{CMYK: 100, 79, 47, 56}, \code{PMS: 539 C}, 
\code{RGB: R16, G38, B59}, or \code{HEX: "#10263B"}.


The deep, rich colour helps the university to be recognisable and 
it’s also associated with trust and respect. 
The colour "black" is no longer part of the Nottingham palette and 
\code{Nottingham blue} should be used as a replacement (this includes body copy).

There are five approved tints that can also be used for variety and to assist legibility. 
HEX codes have been provided for each tint, and these should be used when creating digital artwork, 
rather than using opacity.

Users must choose the correct colour output (RGB for digital and CMYK for print) 
for the asset and its usage.

\code{nottingham_1} uses the HEX color definitions.
}
\examples{
nottingham_1
unikn::seecol(nottingham_1, main = "University of Nottingham 1") # view colour palette

}
\seealso{
\code{\link{nottingham_2}} for supporting colours of the University of Nottingham;
\code{\link{nottingham_3}} for neutral colours of the University of Nottingham;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other UK university color palettes: 
\code{\link{nottingham_2}},
\code{\link{nottingham_3}}
}
\author{
\strong{unicol}, 2023-09-03.
}
\concept{UK university color palettes}
\keyword{datasets}
