% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dundee.R
\docType{data}
\name{dundee_block}
\alias{dundee_block}
\title{Block colours of University of Dundee, Scotland}
\format{
An object of class \code{character} of length 5.
}
\source{
Colour definitions are based on the
\href{https://www.dundee.ac.uk/brand/colour-palette}{Brand colour palette}.
}
\usage{
dundee_block
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{dundee_block} provides the block colours 
of \href{https://www.dundee.ac.uk/}{University of Dundee}, Scotland, UK.
}
\details{
The block colours are intended for colouring larger flat spaces. 
They are subtle and can be used behind photography without overpowering the images. 
Normal usage might include posters and report covers, 
blocks of pull-out content within documents and digital applications, 
colour for graphs etc.The block colours are not intended to be used for typography, 
icons or fine line work, and should not be used as consistent background colour 
throughout a document (for example on multiple pages within a prospectus or report).

The block colours are 
\code{"block_1"} (defined as PANTONE 427C, CMYK 8/4/9/10, RGB 221/217/214, HEX #ddd9d6),
\code{"block_2"} (defined as PANTONE 7520C, CMYK 1/26/21/0, RGB 244/206/195, HEX #f4cec3),
\code{"block_3"} (defined as PANTONE 7506C, CMYK 3/11/30/0, RGB 255/236/210, HEX #ffecd2),
\code{"block_4"} (defined as PANTONE 2707C, CMYK 20/6/0/0, RGB 209/226/242, HEX #d1e2f2), and
\code{"block_5"} (defined as PANTONE 2253C, CMYK 29/0/27/0, RGB 196/235/208, HEX #c4ebd0).

\code{dundee_block} uses the HEX colour definition. 
Pantone and CMYK colours differ from RGB and HEX definition.
}
\examples{
dundee_block
unikn::seecol(dundee_block, main = "Dundee block colours") # view colour palette

}
\seealso{
\code{\link{dundee_core}} for the core colour of University of Dundee;
\code{\link{dundee_highlight}} for the highlight colours of University of Dundee;
\code{\link{dundee_background}} for the background colour of University of Dundee;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Scottish university color palettes: 
\code{\link{dundee_background}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{edinburgh}},
\code{\link{standrews_1}},
\code{\link{standrews_2}}
}
\author{
\strong{unicol}, 2023-06-22.
}
\concept{Scottish university color palettes}
\keyword{datasets}
