% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneAnno.R
\docType{class}
\name{gene-class}
\alias{gene}
\alias{gene-class}
\title{An S4 class to represent a gene.}
\description{
An S4 class to represent a gene.
}
\section{Slots}{

\describe{
\item{\code{name}}{A character string stating the name of the gene as found in NCBI.}

\item{\code{nih_id}}{A numeric value stating the NCBI gene database identifier for the gene.}

\item{\code{nih_summary}}{A character string describing the function and interactions of the gene as found in the NCBI.}

\item{\code{uniprot_name}}{A character string stating the name of the gene as found in Uniprot.}

\item{\code{uniprot_protein_name}}{A character string stating the name of the protein gene product as found in Uniprot.}

\item{\code{uniprot_summary}}{A vector of character strings describing the function and interactions of the gene as found in the Uniprot dataset.}

\item{\code{alternatives}}{A vector of character strings stating commonly used alternative names for the gene (from NCBI).}

\item{\code{symbol}}{A character string stating the offical gene symbol (from NCBI).}

\item{\code{chromosome}}{A character string stating the chromosome upon which the gene resides (from NCBI).}

\item{\code{start}}{A character string stating the chromosomal position of the transcription start (from NCBI).}

\item{\code{stop}}{A character string stating the chromosomal position of the transcription stop (from NCBI).}

\item{\code{exon_count}}{A character stating the number of exons in the gene (from NCBI).}

\item{\code{chraccver}}{A character string stating the NIH accession number and version for the chromosome (from NCBI).}

\item{\code{map_location}}{A character string representing the location of the gene on the karyotype (from NCBI).}

\item{\code{direction}}{A character string [forward/reverse] identifying the direction of the gene on the chromosome (from NCBI).}
}}

