% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheroid.R
\name{simPoissonSystem}
\alias{simPoissonSystem}
\title{Poisson germ-grain process}
\usage{
simPoissonSystem(
  theta,
  lam,
  size = "const",
  shape = "const",
  orientation = "rbetaiso",
  type = c("prolate", "oblate", "spheres", "cylinders"),
  rjoint = NULL,
  box = list(c(0, 1)),
  mu = c(0, 0, 1),
  dz = 0,
  n = c(0, 1, 0),
  intersect = c("original", "full", "only", "digi"),
  delta = 0.01,
  intern = FALSE,
  perfect = FALSE,
  pl = 0,
  label = "N"
)
}
\arguments{
\item{theta}{list of simulation parameters which must consist of elements: \code{size}, \code{shape} and \code{orientation}}

\item{lam}{mean number of objects per unit volume}

\item{size}{name of the size distribution function}

\item{shape}{name of the shape distribution function}

\item{orientation}{name of direction distribution function}

\item{type}{type of grain, either "\code{prolate}" or "\code{oblate}", "\code{spheres}", "\code{cylinders}"}

\item{rjoint}{user-defined function, which specifies the (joint) distribution of the size, shape and orientation}

\item{box}{simulation box}

\item{mu}{main orientation axis, \code{mu=c(0,0,1)} (default)}

\item{dz}{distance of the intersecting plane to the origin}

\item{n}{normal vector defining the intersecting plane}

\item{intersect}{options for type of return values: "\code{full}" for the simulated system together with section profiles as two lists named \code{S} and \code{sp} respectively,
choose "\code{only}" for section profiles only, "\code{original}" for the 3D system only and "\code{digi}" for a (binary) integer matrix \code{W} as a discretized
   version of section profiles whose resolution depends on the chosen lattice constant \code{delta}}

\item{delta}{lattice constant for discretization, set to \code{0.01} (default)}

\item{intern}{logical, \code{FALSE} (default), whether to return only section profiles with centers inside the simulation window}

\item{perfect}{logical, \code{FALSE} (default), whether to simulate exactly (also called perfect)}

\item{pl}{integer, print level and return value type, see details}

\item{label}{character, a label set to each generated object, set to '\code{N}' (default)}
}
\value{
list of 3D objects depending on the chosen return type defined by the argument \code{intersect}
}
\description{
Simulation of Poisson germ-grain processes with either spheres, spheroids or spherocylinders as grains
}
\details{
The function can simulate a Poisson germ-grain process according to the parameter \code{theta} within a predefined (3D) box.
The positions of the germs follow a uniform distribution according to a Poisson process with mean intensity parameter \code{lam}.
The function either randomly generates \code{type="prolate"} or \code{type="oblate"} spheroids, spheres or spherocylinders.
The argument \code{size} sets the name of the distribution function for the size/length of the objects, i.e. the major semi-axis
lengths in case of spheroids, radii for spheres or the lengths of the main axis of rotation for spherocylinders including the end caps. 

The following direction (orientation) distributions of the spheroids' major-axis, respectively, cylinders' main axis are available:
a uniform distribution ("\code{runifdir}"), distribution ("\code{rbetaiso}") and the "\emph{von Mises-Fisher}" ("\code{rvMisesFisher}")
distribution. The two last ones depend on the concentration parameter \code{kappa} which is set as part of the parameter list \code{theta}, see examples below.
The direction distributions generate random spherical coordinates \eqn{(\vartheta, \phi)} w.r.t. a fixed main orientation axis \code{mu}
with polar angle \eqn{\vartheta\in[0,\pi/2)} and azimuthal angle \eqn{\phi\in[0,2\pi)}. The simulations are always performed within a bounding 3D box which consists of a list specifying the ranges of each dimension corresponding to the lower and upper limits of the box in each direction. If the
argument \code{box} contains only a single range, i.e. \code{box=list(c(0,1))}, this limit isassumed for the remaining dimensions which is then simply replicated.
The optional argument \code{rjoint} defines a (joint) distribution function which can be any function provided by the user in order to generate
the required distributional parameters for the spheroids or spherocylinders. For an in-depth example of usage please see the workflow in 'simSpheroids.R'
and 'simCylinders.R'. 

In addition, the function supports an exact simulation type [2] of the grains. In case of spheroids and spherocylinders setting \code{size="rbinorm"}
declares a bivariate size-shape distribution for which the exact simulation is available. More specifically, for a bivariate normal random vector \eqn{[X,Y]}
with correlation parameter \eqn{\rho}, the length of the major semi-axis of a spheroid is given by \eqn{a=exp(x)} with a (logit-transformed) shape parameter
as \eqn{s=1/(1+exp(-y))} and thus a scaled minor semi-axis length \eqn{c=a*s}. The modification leads to a log-normally distributed length of the
major semi-axis. Consequently, in case of spherocylinders, the log-normally distributed length is \eqn{len=h+2*r} where \code{h} is the height and
\eqn{r=len/2*s} the radius. The main direction \code{u} of a spheroid or spherocylinder is determined by the major axis independent of size and shape.
Further, the following univariate distributions of the major semi-axis \code{a}, respectively, length \code{len} and shape \code{s} are available:
'\code{rbeta}', '\code{rgamma}', '\code{rlnorm}' and '\code{runif}'. One can also use '\code{const}' for simulations with constant lengths or shapes.
Note that only simulations with size distributions '\code{rbinorm}' or '\code{rlnorm}' can use the exact type of simulation.

For spheres any distribution of the radii can be specified as a name of a user-defined function in the argument \code{size} as long as the formal named
function parameters match the actual names of the parameters exactly as defined in \code{theta}. Besides this, all other distributions given above are
also available. Using '\code{const}' simulates spheres of constant radii. 
 
The argument \code{pl>=0} denotes both the print level of intermediate output and by the same time the type of the return value. If \code{pl=10},
then an abbreviated list of spheroids or spheres is returned to speed up computation. Note that, the current implementation does not include routines
for unfolding the joint size-shape-orientation distribution of spherocylinders so far.
}
\examples{
 # intensity parameter
 lam <- 100

 # simulation bounding box
 box <- list("xrange"=c(0,5),"yrange"=c(0,5),"zrange"=c(0,5))

 # log normal size distribution with a constant shape factor and
 # concentration parameter (\code{kappa=1}) for the orientation, see reference [1] 
 theta <- list("size"=list("meanlog"=-2.5,"sdlog"=0.5),
               "shape"=list("s"=0.5),
               "orientation"=list("kappa"=1))

 S <- simPoissonSystem(theta,lam,size="rlnorm",box=box,type="oblate",pl=1) 
 length(S)

}
\references{
\itemize{
	\item{} {Ohser, J. and Schladitz, K. 3D images of materials structures Wiley-VCH, 2009}
     \item{} {C. Lantu\eqn{\acute{\textrm{e}}}joul. Geostatistical simulation. Models and algorithms.
					Springer, Berlin, 2002. Zbl 0990.86007}
	  }
}
\author{
M. Baaske
}
