% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/spheroid.R
\name{coefficientMatrixSpheroids}
\alias{coefficientMatrixSpheroids}
\title{Calculate coefficients (spheroids)}
\usage{
coefficientMatrixSpheroids(breaks, stype = c("prolate", "oblate"),
  check = TRUE, nCores = getOption("par.unfoldr", 1))
}
\arguments{
\item{breaks}{list of bin vectors}

\item{stype}{string, either \code{prolate} or \code{oblate}}

\item{check}{logical, whether to run some input checks}

\item{nCores}{number of cores used to calculate the coefficients}
}
\value{
coefficient array
}
\description{
Calculate coefficients of discretized integral equation
}
\details{
In order to apply the EM algorithm to the stereological
unfolding procedure for the joint size-shape-orientation distribution
one first has to calculate the coefficients of the discretized integral
equation. This step is the most time consuming part of unfolding
the parameters and therefore has been separated in its own function.
Further, the number of classes for size, shape and orientation do not
need to be equal, whereas the same class limits are used for binning spatial and planar values.
This might be changed in future releases.
Using multiple cpu cores is controlled by either setting the option 'par.unfoldr' in the global
R environment or passing the number of cores \code{nCores} directly.
}
\examples{
#options(par.unfoldr=1)
breaks <- setbreaks(c(8,6,7),maxSize=0.37,kap=1.25)

breaks

P <- coefficientMatrixSpheroids(breaks,check=FALSE)
c(min(P),max(P),sum(P))
}

