% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{separability}
\alias{separability}
\title{Separability}
\usage{
separability(repetition_and_path_log, xml_internal_doc, signavio = FALSE)
}
\arguments{
\item{repetition_and_path_log}{repetition and path log list object created by the function create_repetition_and_path_log}

\item{xml_internal_doc}{document object created using the create_internal_document function}

\item{signavio}{boolean which indicates whether the file stems from signavio}
}
\value{
an integer indicating the separability
}
\description{
{A cut vertex is a node which if removed, splits the diagram into two pieces
The consequence is that elements which are part of each path can be defined as a cut vertex
Separability is defined as the number of cut vertices divided by (the size of the model - 2)}
}
\examples{
\dontshow{file_path <- system.file("extdata", "doc.txt", package="understandBPMN")
path_log <- create_path_and_repetition_log(create_internal_doc(file_path))}
separability(path_log, create_internal_doc(file_path))
}
