% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{cross_connectivity}
\alias{cross_connectivity}
\title{Cross Connectivity}
\usage{
cross_connectivity(repetition_and_path_log, xml_internal_doc,
  signavio = FALSE)
}
\arguments{
\item{repetition_and_path_log}{repetition and path log list object created by the function create_repetition_and_path_log}

\item{xml_internal_doc}{document object created using the create_internal_document function}

\item{signavio}{boolean which indicates whether the file stems from signavio}
}
\value{
an integer indicating the cross connectivity of a model
}
\description{
The cross-connectivity metric that measures the strength of the links between process model elements.
The definition of this new metric builds on the hypothesis that process models are easier understood and contain less errors if they have a high cross-connectivity.
The metric is calculated based on the creation of a data frame containing the values of all connections
}
\examples{
\dontshow{file_path <- system.file("extdata", "doc.txt", package="understandBPMN")
path_log <- create_path_and_repetition_log(create_internal_doc(file_path))}
cross_connectivity(path_log, create_internal_doc(file_path))
}
