% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create_path_log.R
\name{create_path_and_repetition_log}
\alias{create_path_and_repetition_log}
\title{Path and repetition log}
\usage{
create_path_and_repetition_log(xml_internal_doc,
  add_path_log_for_structuredness = TRUE, signavio = FALSE)
}
\arguments{
\item{xml_internal_doc}{internal document containing an xml}

\item{add_path_log_for_structuredness}{a boolean value indicating whether the structured path log should be added. Is standard TRUE}

\item{signavio}{boolean which indicates whether the file stems from signavio}
}
\value{
a list containing the path log, a list of repetitions starting with join, a list of repetitions starting with split, (optional: structured path log)
}
\description{
{This function returns a list with four or three nested list objects:
- One for the paths:
Assumption: if a path contains a loop, the path contains one repetition (so two times) of the execution of this loop
Assumption: there is no difference made between the type of gateways.
So the path log is not a path log according to the definition found in the literature, but more a kind of a path log
Assumption: for each split and join in the log, an extra element is added with the name "split" or "join"
- One list object for the loops (repetitions) which start with a join and end with a join
- One list object for the loops (repetitions) which start with a split and end with a split
( - One list for the paths in which all gateways have a certain type)}
}
\examples{
\dontshow{file_path <- system.file("extdata", "doc.txt", package="understandBPMN")}
create_path_and_repetition_log(create_internal_doc(file_path))
}
