% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_select_valid}
\alias{umx_select_valid}
\title{Update NA values in one column with valid entries from another}
\usage{
umx_select_valid(col1, col2, bothways = FALSE, data)
}
\arguments{
\item{col1}{name of the first column}

\item{col2}{name of the second column}

\item{bothways}{Whether to replace from 1 to 2 as well as from 2 to 1}

\item{data}{The dataframe containing the two columns.}
}
\value{
\itemize{
\item Updated dataframe
}
}
\description{
Merge valid entries from two columns
}
\examples{
tmp = mtcars
tmp$newDisp = tmp$disp
tmp$disp[c(1,3,6)] = NA
anyNA(tmp$disp) # column has NAs
tmp = umx_select_valid("disp", "newDisp", data = tmp)
anyNA(tmp$disp) # column repaired
}
\seealso{
\itemize{
\item \code{\link[=within]{within()}}
}

Other Data Functions: 
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_read_prolific_demog}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_score_scale}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
