% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxWeightedAIC}
\alias{umxWeightedAIC}
\title{AIC weight-based conditional probabilities.}
\usage{
umxWeightedAIC(models, digits = 2)
}
\arguments{
\item{models}{a list of models to compare.}

\item{digits}{(default 2)}
}
\value{
\itemize{
\item Best model
}
}
\description{
Returns the best model by AIC, and computes the probabilities
according to AIC weight-based conditional probabilities (Wagenmakers & Farrell, 2004).
}
\examples{
l1 = lm(mpg~ wt + disp, data=mtcars)
l2 = lm(mpg~ wt, data=mtcars)
umxWeightedAIC(models = list(l1, l2))
}
\references{
\itemize{
\item Wagenmakers E.J., Farrell S. (2004), 192-196. AIC model selection using Akaike weights. \emph{Psychonomic Bulletin and Review}. \strong{11}, 192-196. \url{https://pubmed.ncbi.nlm.nih.gov/15117008/}
}
}
\seealso{
\itemize{
\item \code{\link[=AIC]{AIC()}}
}

Other Miscellaneous Stats Helpers: 
\code{\link{FishersMethod}()},
\code{\link{SE_from_p}()},
\code{\link{geometric_mean}()},
\code{\link{harmonic_mean}()},
\code{\link{oddsratio}()},
\code{\link{reliability}()},
\code{\link{umxCov2cor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_apply}()},
\code{\link{umx_cor}()},
\code{\link{umx_means}()},
\code{\link{umx_r_test}()},
\code{\link{umx_round}()},
\code{\link{umx_scale}()},
\code{\link{umx_var}()},
\code{\link{umx}}
}
\concept{Miscellaneous Stats Helpers}
