% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxModify}
\alias{umxModify}
\title{umxModify: Add, set, or drop model paths by label.}
\usage{
umxModify(
  lastFit,
  update = NULL,
  regex = FALSE,
  free = FALSE,
  value = 0,
  newlabels = NULL,
  freeToStart = NA,
  name = NULL,
  comparison = FALSE,
  autoRun = getOption("umx_auto_run"),
  tryHard = c("no", "yes", "ordinal", "search"),
  master = NULL,
  intervals = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{lastFit}{The \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}} you wish to update and run.}

\item{update}{What to update before re-running. Can be a list of labels, a regular expression (set regex = TRUE) or an object such as mxCI etc.}

\item{regex}{Whether or not update is a regular expression (default FALSE). If you provide a string, it overrides the contents of update, and sets regex to TRUE.}

\item{free}{The state to set "free" to for the parameters whose labels you specify (defaults to free = FALSE, i.e., fixed)}

\item{value}{The value to set the parameters whose labels you specify too (defaults to 0)}

\item{newlabels}{If not NULL, used as a replacement set of labels (can be regular expression). value and free are ignored!}

\item{freeToStart}{Whether to update parameters based on their current free-state. free = c(TRUE, FALSE, NA), (defaults to NA - i.e, not checked)}

\item{name}{The name for the new model}

\item{comparison}{Whether to run umxCompare() on the new and old models.}

\item{autoRun}{Whether to run the model (default), or just to create it and return without running.}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{master}{If you set master, then the update labels will be equated to these (i.e. replaced by them).}

\item{intervals}{Whether to run confidence intervals (see \code{\link[OpenMx:mxRun]{OpenMx::mxRun()}})}

\item{verbose}{How much feedback to give}
}
\value{
\itemize{
\item \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}
}
}
\description{
umxModify allows you to modify, re-run and summarize an \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}, all in one line of script.
}
\details{
You can add paths, or other model elements, set path values (default is 0), or replace labels.
As an example, this one-liner drops a path labelled "Cs", and returns the updated model:

\code{fit2 = umxModify(fit1, update = "Cs", name = "newModelName", comparison = TRUE)}

Regular expressions are a powerful feature: they let you drop collections of paths by matching patterns
for instance, this would match labels containing either "Cs" or "Cr":

\if{html}{\out{<div class="sourceCode R">}}\preformatted{fit2 = umxModify(fit1, regex = "C\[sr\]", name = "drop_Cs_and_Cr", comparison = TRUE)
}\if{html}{\out{</div>}}

You may find it easier to be more explicit. Like this:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{fit2 = umxSetParameters(fit1, labels = c("Cs", "Cr"), values = 0, free = FALSE, name = "newName")
fit2 = mxRun(fit2)
summary(fit2)
}\if{html}{\out{</div>}}

\emph{Note}: A (minor) limitation is that you cannot simultaneously set value to 0
AND relabel cells (because the default value is 0, so it is ignored when using newlabels).
}
\examples{
\dontrun{
require(umx)
# First we'll just build a 1-factor model
umx_set_optimizer("SLSQP")
data(demoOneFactor)
manifests = names(demoOneFactor)

m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)

# 1. Drop the path to x1 (also updating the name so it's
#    self-explanatory, and get a fit comparison
m2 = umxModify(m1, update = "G_to_x1", name = "drop_X1", comparison = TRUE)

# 2. Add the path back (setting free = TRUE)
m2 = umxModify(m1, update = "G_to_x1", free= TRUE, name = "addback_X1", comparison = TRUE)
# 3. Fix a value at a non-zero value
m3 = umxModify(m1, update = "G_to_x1", value = .35, name = "fix_G_x1_at_35", comp = TRUE)
# You can add objects to models. For instance this would add a path (overwriting the existing one)
# (thanks Johannes!)
m3 = umxModify(m1, umxPath("G", with = "x1"), name= "addedPath")

# Use regular expression to drop multiple paths: e.g. G to x3, x4, x5
m3 = umxModify(m1, regex = "^G_to_x[3-5]", name = "tried_hard", comp = TRUE, tryHard="yes")

# Same, but don't autoRun
m2 = umxModify(m1, regex  = "^G_to_x[3-5]", name = "no_G_to_x3_5", autoRun = FALSE) 

# Re-write a label
newLabel = "A_rose_by_any_other_name"
newModelName = "model_doth_smell_as_sweet"
m2 = umxModify(m1, update = "G_to_x1", newlabels= newLabel, name = newModelName, comparison = TRUE)
# Change labels in 2 places
labsToUpdate = c("G_to_x1", "G_to_x2")
newLabel = "G_to_1_or_2"
m2 = umxModify(m1, update = labsToUpdate, newlabels= newLabel, name = "equated", comparison = TRUE)

# Advanced!
# Regular expressions let you use pieces of the old names in creating new ones!
searchString = "G_to_x([0-9])"
newLabel = "loading_for_path\\\\1" # use value in regex group 1
m2 = umxModify(m1, regex = searchString, newlabels= newLabel, name = "grep", comparison = TRUE)
} # end dontrun

}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Core Model Building Functions: 
\code{\link{umx}},
\code{\link{umxMatrix}()},
\code{\link{umxPath}()},
\code{\link{umxRAM}()},
\code{\link{umxSuperModel}()}
}
\concept{Core Model Building Functions}
