% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_reorder}
\alias{umx_reorder}
\title{Reorder or drop variables from a correlation/covariance matrix.}
\usage{
umx_reorder(old, newOrder, force = FALSE)
}
\arguments{
\item{old}{a square matrix of correlation or covariances to reorder}

\item{newOrder}{Variables you want in the order you wish to have}

\item{force}{Just assume input is value (default = FALSE)}
}
\value{
- the re-ordered/resized matrix
}
\description{
Reorder the variables in a correlation matrix. Can also remove one or more variables from a matrix using this function.
}
\examples{
oldMatrix = cov(mtcars)
umx_reorder(oldMatrix, newOrder = c("mpg", "cyl", "disp")) # first 3
umx_reorder(oldMatrix, newOrder = c("hp", "disp", "cyl")) # subset and reordered
umx_reorder(oldMatrix, "hp") # edge-case of just 1-var
}
\references{
- <https://www.github.com/tbates/umx>
}
\seealso{
Other Data Functions: \code{\link{umxFactor}()},
  \code{\link{umxHetCor}()},
  \code{\link{umx_as_numeric}()},
  \code{\link{umx_cont_2_quantiles}()},
  \code{\link{umx_lower2full}()},
  \code{\link{umx_make_MR_data}()},
  \code{\link{umx_make_TwinData}()},
  \code{\link{umx_make_fake_data}()},
  \code{\link{umx_make_raw_from_cov}()},
  \code{\link{umx_polychoric}()},
  \code{\link{umx_polypairwise}()},
  \code{\link{umx_polytriowise}()},
  \code{\link{umx_read_lower}()},
  \code{\link{umx_rename}()},
  \code{\link{umx_select_valid}()},
  \code{\link{umx_stack}()}, \code{\link{umx}},
  \code{\link{xmu_data_swap_a_block}()}
}
\concept{Data Functions}
