% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_paste_names}
\alias{umx_paste_names}
\alias{tvars}
\title{Concatenate base variable names with suffixes to create wide-format variable names (i.e twin-format)}
\usage{
umx_paste_names(
  varNames,
  sep = "",
  suffixes = 1:2,
  covNames = NULL,
  prefix = NULL
)
}
\arguments{
\item{varNames}{a list of \emph{base} names, e.g c("bmi", "IQ")}

\item{sep}{A string separating the name and the twin suffix, e.g. "_T" (default is "")}

\item{suffixes}{a list of terminal suffixes differentiating the twins default = 1:2)}

\item{covNames}{a list of \emph{base} names for covariates (to be sorted last in list), e.g c("age", "sex")}

\item{prefix}{a string to prepend to each label, e.g "mean" -> "mean_age" "mean_sex"}
}
\value{
\itemize{
\item vector of suffixed var names, i.e., c("v1_T1", "v2_T1", "v1_T2", "v2_T2", "cov_T1", "cov_T2")
}
}
\description{
It's easier to work with base names, rather than the twice-as-long hard-to-typo list of column names.
\code{umx_paste_names} adds suffixes to names so you can work with that nice short list.
So, you provide \code{bmi}, and you get back fully specified family-wise names: \code{c("bmi_T1", "bmi_T2")}

\emph{note}: \code{tvars} is a shortcut for \code{umx_paste_names}
}
\details{
\strong{Method 1}: \emph{Use complete suffixes}

You can provide complete suffixes like "_T1" and "_T2". This has the benefit of being explicit
and very general:\preformatted{umx_paste_names(c("var1", "var2"), suffixes = c("_T1", "_T2"))
}

\emph{Note}: for quick typing, \code{tvars} is an alias for \code{umx_paste_names}

\strong{Method 2}: \emph{Use sep and a suffix vector.}

Alternatively, you can use \code{sep} to add a constant like "_T" after each basename, along
with a vector of suffixes. This has the benefit of showing what is varying:
This is then suffixed with e.g. "1", "2".\preformatted{umx_paste_names(c("var1", "var2"), sep = "_T", suffixes = 1:2)
}

\emph{Working with covariates}

If you are using \code{\link[=umxACEcov]{umxACEcov()}}, you \strong{need} to keep all the covariates at the end of the list.
Here's how:\preformatted{umx_paste_names(c("var1", "var2"), cov = c("cov1"), sep = "_T", suffixes = 1:2)
}

\emph{note}: in conventional twin models, the expCov matrix is T1 vars, followed by T2 vars. For covariates, you want
T1vars, T2 vars, T1 covs, T2 covs. This is what \code{covNames} accomplishes.
}
\examples{
# two styles doing the same thing: first is more general
umx_paste_names("bmi", suffixes = c("_T1", "_T2"))
umx_paste_names("bmi", sep = "_T", suffixes = 1:2)
varNames = umx_paste_names(c("N", "E", "O", "A", "C"), "_T", 1:2)
umx_paste_names(c("IQ", "C"), cov = c("age"), sep = "_T", suffixes = 1:2)
umx_paste_names(c("IQ", "C"), cov = c("age"), sep = "_T", prefix= "mean_")
# For quick-typing, tvars is an alias for umx_paste_names
tvars(c("IQ", "C"), cov = c("age"), sep = "_T", prefix= "mean_")
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
\code{\link[=namez]{namez()}}

Other String Functions: \code{\link{umx_explode_twin_names}()},
  \code{\link{umx_explode}()}, \code{\link{umx_grep}()},
  \code{\link{umx_names}()},
  \code{\link{umx_object_as_str}()},
  \code{\link{umx_rot}()}, \code{\link{umx_trim}()},
  \code{\link{umx_write_to_clipboard}()}, \code{\link{umx}}
}
\concept{String Functions}
