% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_has_been_run}
\alias{umx_has_been_run}
\title{umx_has_been_run}
\usage{
umx_has_been_run(model, stop = FALSE)
}
\arguments{
\item{model}{The \code{\link[=mxModel]{mxModel()}} you want to check has been run}

\item{stop}{Whether to stop if the model has not been run (defaults to FALSE)}
}
\value{
\itemize{
\item boolean
}
}
\description{
check if an mxModel has been run or not
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("has_been_run_example", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)#'
umx_has_been_run(m1)
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
Other Test: \code{\link{umx_check_OS}()},
  \code{\link{umx_check_model}()},
  \code{\link{umx_check_names}()},
  \code{\link{umx_check_parallel}()},
  \code{\link{umx_check}()}, \code{\link{umx_has_CIs}()},
  \code{\link{umx_has_means}()},
  \code{\link{umx_has_square_brackets}()},
  \code{\link{umx_is_MxData}()},
  \code{\link{umx_is_MxMatrix}()},
  \code{\link{umx_is_MxModel}()},
  \code{\link{umx_is_RAM}()}, \code{\link{umx_is_cov}()},
  \code{\link{umx_is_ordered}()}
}
\concept{Test}
