% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_high_level_models.R
\name{umxFactorScores}
\alias{umxFactorScores}
\title{Return factor scores from a model as an easily consumable dataframe.}
\usage{
umxFactorScores(
  model,
  type = c("ML", "WeightedML", "Regression"),
  minManifests = NA,
  return = c("Scores", "StandardErrors")
)
}
\arguments{
\item{model}{The model from which to generate scores.}

\item{type}{Method of computing the score ('ML', 'WeightedML', or 'Regression').}

\item{minManifests}{The minimum number of variables not NA to return a score for a participant (Default = ask).}

\item{return}{What to return (defaults to "Scores", which is what most users want, but can return "StandardErrors" on each score.}
}
\value{
\itemize{
\item dataframe of scores.
}
}
\description{
umxFactorScores takes a model, and computes factors scores using the selected method (one
of 'ML', 'WeightedML', or 'Regression')
It is a simple wrapper around mxFactorScores. For missing data, you must specify the least number of
variables allowed for a score (subjects with fewer than minManifests will return a score of NA.
}
\examples{
m1 = umxEFA(mtcars, factors = 2)
x = umxFactorScores(m1, type = 'Regression', minManifests = 3)

# =========================================================================
# = histogram of F1 and plot of F1 against F2 showing they are orthogonal =
# =========================================================================
hist(x$F1)
plot(F1 ~ F2, data = x)

\dontrun{
m1 = umxEFA(mtcars, factors = 1)
x = umxFactorScores(m1, type = 'Regression', minManifests = 3)
x
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=mxFactorScores]{mxFactorScores()}}
}

Other Reporting Functions: \code{\link{FishersMethod}()},
  \code{\link{loadings.MxModel}()},
  \code{\link{tmx_is.identified}()},
  \code{\link{tmx_show}()}, \code{\link{umxAPA}()},
  \code{\link{umxGetParameters}()},
  \code{\link{umxParameters}()}, \code{\link{umxReduce}()},
  \code{\link{umxWeightedAIC}()},
  \code{\link{umx_APA_pval}()},
  \code{\link{umx_aggregate}()}, \code{\link{umx_names}()},
  \code{\link{umx_print}()}, \code{\link{umx_time}()},
  \code{\link{umx}}
}
\concept{Reporting Functions}
