% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{xmu_describe_data_WLS}
\alias{xmu_describe_data_WLS}
\title{Determine whether a dataset will need weights and summary statistics for the means if used with mxFitFunctionWLS}
\usage{
xmu_describe_data_WLS(data, allContinuousMethod = c("cumulants",
  "marginals"), verbose = FALSE)
}
\arguments{
\item{data}{The raw data being used in a \code{\link[=mxFitFunctionWLS]{mxFitFunctionWLS()}} model.}

\item{allContinuousMethod}{the method used to process data when all columns are continuous (default = "cumulants")}

\item{verbose}{Whether or not to report diagnostics.}
}
\value{
\itemize{
\item list describing the data.
}
}
\description{
Given either a data.frame or an mxData of type raw, this function determines whether \code{\link[=mxFitFunctionWLS]{mxFitFunctionWLS()}}
will generate expectations for means.
}
\details{
All-continuous models processed using the "cumulants" method lack means, while
all continuous processed with allContinuousMethod = "marginals" will have means.

When data are not all continuous, allContinuousMethod is ignored, and means are modeled.
}
\examples{

# ====================================
# = All continuous, data.frame input =
# ====================================

tmp =xmu_describe_data_WLS(mtcars, allContinuousMethod= "cumulants", verbose = TRUE)
tmp$hasMeans # FALSE - no means with cumulants
tmp =xmu_describe_data_WLS(mtcars, allContinuousMethod= "marginals") 
tmp$hasMeans # TRUE we get means with marginals

# ==========================
# = mxData object as input =
# ==========================
tmp = mxData(mtcars, type="raw")
xmu_describe_data_WLS(tmp, allContinuousMethod= "cumulants", verbose = TRUE)$hasMeans # FALSE
xmu_describe_data_WLS(tmp, allContinuousMethod= "marginals")$hasMeans  # TRUE

# =======================================
# = One var is a factor: Means modeled =
# =======================================
tmp = mtcars
tmp$cyl = factor(tmp$cyl)
xmu_describe_data_WLS(tmp, allContinuousMethod= "cumulants")$hasMeans # TRUE - always has means
xmu_describe_data_WLS(tmp, allContinuousMethod= "marginals")$hasMeans # TRUE

}
\seealso{
\itemize{
\item \code{\link[=mxFitFunctionWLS]{mxFitFunctionWLS()}}, \code{\link[=omxAugmentDataWithWLSSummary]{omxAugmentDataWithWLSSummary()}}
}

Other xmu internal not for end user: \code{\link{umxModel}()},
  \code{\link{umx_standardize}()}, \code{\link{umx}},
  \code{\link{xmuHasSquareBrackets}()},
  \code{\link{xmuLabel_MATRIX_Model}()},
  \code{\link{xmuLabel_Matrix}()},
  \code{\link{xmuLabel_RAM_Model}()},
  \code{\link{xmuMI}()},
  \code{\link{xmuMakeDeviationThresholdsMatrices}()},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}()},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}()},
  \code{\link{xmuMaxLevels}()},
  \code{\link{xmuMinLevels}()},
  \code{\link{xmuPropagateLabels}()},
  \code{\link{xmu_CI_merge}()},
  \code{\link{xmu_CI_stash}()},
  \code{\link{xmu_DF_to_mxData_TypeCov}()},
  \code{\link{xmu_PadAndPruneForDefVars}()},
  \code{\link{xmu_assemble_twin_supermodel}()},
  \code{\link{xmu_check_levels_identical}()},
  \code{\link{xmu_check_needs_means}()},
  \code{\link{xmu_check_variance}()},
  \code{\link{xmu_clean_label}()},
  \code{\link{xmu_dot_make_paths}()},
  \code{\link{xmu_dot_make_residuals}()},
  \code{\link{xmu_dot_maker}()},
  \code{\link{xmu_dot_move_ranks}()},
  \code{\link{xmu_dot_rank_str}()},
  \code{\link{xmu_get_CI}()},
  \code{\link{xmu_lavaan_process_group}()},
  \code{\link{xmu_make_bin_cont_pair_data}()},
  \code{\link{xmu_make_mxData}()},
  \code{\link{xmu_make_top_twin}()},
  \code{\link{xmu_name_from_lavaan_str}()},
  \code{\link{xmu_safe_run_summary}()},
  \code{\link{xmu_set_sep_from_suffix}()},
  \code{\link{xmu_show_fit_or_comparison}()},
  \code{\link{xmu_simplex_corner}()},
  \code{\link{xmu_standardize_ACEcov}()},
  \code{\link{xmu_standardize_ACEv}()},
  \code{\link{xmu_standardize_ACE}()},
  \code{\link{xmu_standardize_CP}()},
  \code{\link{xmu_standardize_IP}()},
  \code{\link{xmu_standardize_RAM}()},
  \code{\link{xmu_standardize_SexLim}()},
  \code{\link{xmu_standardize_Simplex}()},
  \code{\link{xmu_start_value_list}()},
  \code{\link{xmu_starts}()},
  \code{\link{xmu_twin_check}()}
}
\concept{xmu internal not for end user}
