% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_nice_data.R
\name{umx_nice_data}
\alias{umx_nice_data}
\title{Convert a twin dataset into umx standard format.}
\usage{
umx_nice_data(data, sep, zygosity)
}
\arguments{
\item{data}{a \code{\link[=data.frame]{data.frame()}} to check/convert.}

\item{sep}{existing separator string (updated to "_T").}

\item{zygosity}{existing zygosity column name (updated to \code{zygosity}).}
}
\value{
\itemize{
\item \code{\link[=data.frame]{data.frame()}}
}
}
\description{
\code{umx_nice_data} is a function to convert your twin data into a format used across \code{umx}. Specifically:
\enumerate{
\item zygosity is stored in a column called "zygosity".
\item sep is set to "_T"
}
}
\examples{
tmp = umx_nice_data(twinData, sep="", zyg="zygosity")
namez(tmp)
# m1 = umxACE("wt")

}
\references{
\itemize{
\item \href{https://tbates.github.io}{tutorials}, \href{https://github.com/tbates/umx}{tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=umx_wide2long]{umx_wide2long()}}, \code{\link[=umx_long2wide]{umx_long2wide()}},
}

Other Twin Data functions: \code{\link{umx_long2wide}()},
  \code{\link{umx_make_TwinData}()},
  \code{\link{umx_residualize}()},
  \code{\link{umx_scale_wide_twin_data}()},
  \code{\link{umx_wide2long}()}, \code{\link{umx}}
}
\concept{Twin Data functions}
