% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_fix_first_loadings}
\alias{umx_fix_first_loadings}
\title{umx_fix_first_loadings}
\usage{
umx_fix_first_loadings(model, latents = NULL, at = 1,
  freeFixedLatent = TRUE)
}
\arguments{
\item{model}{An \code{\link[=mxModel]{mxModel()}} to set.}

\item{latents}{Which latents to fix from (NULL = all).}

\item{at}{The value to fix the first path at (Default = 1).}

\item{freeFixedLatent}{Whether to free a latent if it is fixed (default = TRUE)}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Fix the loading of the first path from each latent at selected value. Seldom used; might be useful to show students
how to scale models with fixed latent or fixed first path...
\emph{Note}: latents with fixed variance are toggled by default (change made in 2019).
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("fix_first", data = demoOneFactor, type = "cov",
	umxPath("g", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "g", fixedAt = 1.0)
)

m1 = umx_fix_first_loadings(m1, latents = "g")
tmx_show(m1, "free", matrices="A") # path from g to var1 fixed @ 1.
# note, in practice, you would now need to free the variance of g
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Advanced Model Building Functions: \code{\link{umxJiggle}()},
  \code{\link{umxLabel}()}, \code{\link{umxRAM2Ordinal}()},
  \code{\link{umxThresholdMatrix}()},
  \code{\link{umxValues}()},
  \code{\link{umx_fix_latents}()},
  \code{\link{umx_get_bracket_addresses}()},
  \code{\link{umx_string_to_algebra}()}, \code{\link{umx}}
}
\concept{Advanced Model Building Functions}
