% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_make}
\alias{umx_make}
\title{"make" the umx package using devtools: release to CRAN etc.}
\usage{
umx_make(what = c("install", "examples", "check", "win", "rhub", "release"),
  pkg = "~/bin/umx", check = TRUE)
}
\arguments{
\item{what}{whether to "install", "release" to CRAN, check on "win", "check", or "examples"))}

\item{pkg}{the local path to your package. Defaults to my path to umx.}

\item{check}{Whether to run check on the package before release (default = TRUE)}
}
\value{
-
}
\description{
Easily  run devtools "install", "release", "win", or "examples".
}
\examples{
\dontrun{
umx_make(what = "install"))  # just installs the package
umx_make(what = "examples")) # run the examples
umx_make(what = "check"))    # run R CMD check
umx_make(what = "win"))      # check on win-builder
umx_make(what = "release"))  # release to CRAN
}
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Miscellaneous Utility Functions: \code{\link{install.OpenMx}},
  \code{\link{qm}}, \code{\link{umxBrownie}},
  \code{\link{umxVersion}}, \code{\link{umx_find_object}},
  \code{\link{umx_msg}}, \code{\link{umx_open_CRAN_page}},
  \code{\link{umx_pb_note}}, \code{\link{umx_print}},
  \code{\link{umx}}
}
