% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_wide2long}
\alias{umx_wide2long}
\title{Change data 2-twin family data from wide to long format.}
\usage{
umx_wide2long(data, sep = "_T", verbose = FALSE)
}
\arguments{
\item{data}{a dataframe containing twin data.}

\item{sep}{the string between the var name and twin suffix, i.e., var_T1 = _T}

\item{verbose}{Report the non-twin and twin columns (default = FALSE).}
}
\value{
- long-format dataframe
}
\description{
Just detects the data columns for twin 1, and twin 2, then returns them stacked
on top of each other (rbind) with the non-twin specific columns copied for each as well.
}
\examples{
long = umx_wide2long(data = twinData, sep = "")
long = umx_wide2long(data = twinData, sep = "", verbose = TRUE)
str(long)
str(twinData)
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_long2wide}},
  \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}

Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}},
  \code{\link{umxACE_cov_fixed}}, \code{\link{umxACEcov}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCF_SexLim}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxE}},
  \code{\link{umxIP}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxReduceACE}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_long2wide}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
