% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_cont_2_quantiles}
\alias{umx_cont_2_quantiles}
\title{umx_cont_2_quantiles}
\usage{
umx_cont_2_quantiles(x, nlevels = NULL, type = c("mxFactor", "ordered",
  "unordered"), verbose = FALSE)
}
\arguments{
\item{x}{a variable to recode as ordinal (email me if you'd like this upgraded to handle df input)}

\item{nlevels}{How many bins or levels (at most) to use (i.e., 10 = deciles)}

\item{type}{what to return (Default is "mxFactor") options include
"ordered" and "unordered")}

\item{verbose}{report the min, max, and decile cuts used (default = FALSE)}
}
\value{
- recoded variable as an \code{\link{mxFactor}}
}
\description{
Recode a continuous variable into n-quantiles (default = deciles (10 levels)).
It returns an \code{\link{mxFactor}}, with the levels labeled with the max value
in each quantile (i.e., open on the left-side).
}
\details{
\strong{Note}: Redundant bins are merged. i.e., if the same score identifies
all deciles up to the fourth, then these will be merged into one level.
}
\examples{
x = umx_cont_2_quantiles(rnorm(1000), nlevels = 10, verbose = TRUE)
levels(x)
x = umx_cont_2_quantiles(mtcars[,"mpg"], 5) # quintiles
x = umx_cont_2_quantiles(mtcars[,"cyl"], 10)
# x = umx_cont_2_quantiles(mtcars[,1:3])
x = umx_cont_2_quantiles(rep(0:10, 10), nlevels = 10)
x = umx_cont_2_quantiles(rbinom(10000, 1, .5), nlevels = 2)
str(umx_cont_2_quantiles(rnorm(10000), nlevels = 4, verbose = TRUE))
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}}, \code{\link{umx_cov2raw}},
  \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}
}

