% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxSE.R
\name{mxSE}
\alias{mxSE}
\title{mxSE - Compute standard errors in OpenMx}
\usage{
mxSE(x, model, ...)
}
\arguments{
\item{x}{the parameter to get SEs on (reference or expression)}

\item{model}{the \code{\link{mxModel}} to use.}

\item{...}{further named arguments passed to \code{\link{mxEval}}}
}
\value{
SE value(s) returned as a matrix.
}
\description{
This function allows you to obtain standard errors for arbitrary
expressions, named entities, and algebras.
}
\details{
x can be the name of an algebra, a bracket address, named entity
or arbitrary expression. It is a frontend-only file that works
much like mxEval.
}
\examples{
library(OpenMx)
data(demoOneFactor)
# ===============================
# = Make and run a 1-factor CFA =
# ===============================

latents  = c("G") # the latent factor
manifests = names(demoOneFactor) # manifest variables to be modeled
# ===========================
# = Make and run the model! =
# ===========================
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = mxRun(m1)
mxSE('A', model = m1)
mxSE((A + A) \%*\% S, model = m1)
mxSE(S, model = m1)
mxSE(A[1,2], model = m1)
mxSE(A[1,6]^2, model = m1)
}
\references{
- \url{https://en.wikipedia.org/wiki/Standard_error}
}
\seealso{
- \code{\link{mxCI}}

Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{umxAPA}}, \code{\link{umxSummary}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_print}}, \code{\link{umx_show}},
  \code{\link{umx_time}}, \code{\link{umx}}
}

