% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_make_sql_from_excel}
\alias{umx_make_sql_from_excel}
\title{umx_make_sql_from_excel}
\usage{
umx_make_sql_from_excel(theFile = "Finder")
}
\arguments{
\item{theFile}{The xlsx file to read. If set to "Finder" (and you are on OS X) it will use the current frontmost Finder window. If it is blank, a choose file dialog will be thrown.}
}
\value{
-
}
\description{
Unlikely to be of use to anyone but the package author :-)
Read an xlsx file and convert into SQL insert statements (placed on the clipboard)
On OS X, the function can access the current frontmost Finder window.
}
\details{
The file name should be the name of the test.
Columns should be headed:
itemText	direction	scale	type	[optional	response	options]

The SQL fields generated are:
itemID, test, native_item_number, item_text, direction, scale, format, author
}
\examples{
\dontrun{
# An example xcel spreadsheet
fp = system.file("inst/extdata", "GQ6.sql.xlsx", package = "umx")
umx_open(fp)
umx_make_sql_from_excel() # Using file selected in front-most Finder window
umx_make_sql_from_excel("~/Desktop/test.xlsx") # provide a path
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other File Functions: \code{\link{dl_from_dropbox}},
  \code{\link{umx_move_file}}, \code{\link{umx_open}},
  \code{\link{umx_rename_file}}, \code{\link{umx}}
}

