% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxGxE}
\alias{umxGxE}
\title{umxGxE}
\usage{
umxGxE(name = "G_by_E", selDVs, selDefs, dzData, mzData, suffix = NULL,
  lboundACE = NA, lboundM = NA, dropMissingDef = FALSE,
  autoRun = getOption("umx_auto_run"))
}
\arguments{
\item{name}{The name of the model (defaults to "G_by_E")}

\item{selDVs}{The dependent variable (e.g. IQ)}

\item{selDefs}{The definition variable (e.g. socio economic status)}

\item{dzData}{The DZ dataframe containing the Twin 1 and Twin 2 DV and moderator (4 columns)}

\item{mzData}{The MZ dataframe containing the Twin 1 and Twin 2 DV and moderator (4 columns)}

\item{suffix}{Expand variable base names, i.e., "_T" makes var -> var_T1 and var_T2}

\item{lboundACE}{= numeric: If !is.na, then lbound the main effects at this value (default = NA)}

\item{lboundM}{= numeric: If !is.na, then lbound the moderators at this value (default = NA)}

\item{dropMissingDef}{Whether to automatically drop missing def var rows for the user (gives a warning) default = FALSE}

\item{autoRun}{Whether to run the model, and return that (default), or just to create it and return without running.}
}
\value{
- GxE \code{\link{mxModel}}
}
\description{
Make a 2-group GxE (moderated ACE) model (Purcell, 2002). GxE interaction studies test the hypothesis that the strength
of genetic (or environmental) influence varies parametrically (usuaally linear effects on path estimates)
across levels of environment. umxGxE allows detecting,
testing, and visualizing  G xE (or C or E x E) interaction forms.
}
\details{
The following figure the GxE model as a path diagram:
\figure{GxE.png}
}
\examples{
require(umx)
data(twinData) 
twinData$age1 = twinData$age2 = twinData$age
selDVs  = c("bmi1", "bmi2")
selDefs = c("age1", "age2")
selVars = c(selDVs, selDefs)
mzData  = subset(twinData, zyg == 1, selVars)[1:80,]
dzData  = subset(twinData, zyg == 3, selVars)[1:80,]
m1 = umxGxE(selDVs = selDVs, selDefs = selDefs, 
	dzData = dzData, mzData = mzData, dropMissing = TRUE)
# Plot Moderation
umxSummaryGxE(m1)
umxSummary(m1, location = "topright")
umxSummary(m1, separateGraphs = FALSE)
m2 = umxModify(m1, "am_.*", regex=TRUE, comparison = TRUE)
}
\references{
- Purcell, S. (2002). Variance components models for gene-environment interaction in twin analysis. \emph{Twin Research}, \strong{6}, 554-571. Retrieved from http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&dopt=Citation&list_uids=12573187
}
\seealso{
- \code{\link{plot}()} and \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Twin Modeling Functions: \code{\link{umxACESexLim}},
  \code{\link{umxACEcov}}, \code{\link{umxACE}},
  \code{\link{umxCF_SexLim}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxIP}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_make_TwinData}}, \code{\link{umx}}
}

