% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_set_optimizer}
\alias{umx_set_optimizer}
\title{umx_set_optimizer}
\usage{
umx_set_optimizer(opt = NA, model = NULL)
}
\arguments{
\item{opt}{default (NA) returns current value. Current alternatives are
"NPSOL" "SLSQP" and "CSOLNP".}

\item{model}{A model for which to set the optimizer. Default (NULL) sets the optimizer globally.}
}
\value{
-
}
\description{
Set the optimizer in OpenMx
}
\examples{
library(umx)
old = umx_set_optimizer() # get the existing state
umx_set_optimizer("SLSQP") # update globally
umx_set_optimizer(old) # set back
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Get and set: \code{\link{umx_get_checkpoint}},
  \code{\link{umx_get_cores}},
  \code{\link{umx_get_optimizer}},
  \code{\link{umx_set_auto_run}},
  \code{\link{umx_set_checkpoint}},
  \code{\link{umx_set_cores}}
}

