% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_gazetteer.R
\name{augment_gazetteer}
\alias{augment_gazetteer}
\title{Augments Landmark Gazetteer}
\usage{
augment_gazetteer(
  landmarks,
  landmarks.name_var = "name",
  landmarks.type_var = "type",
  grams.min_words = 3,
  grams.max_words = 6,
  grams.skip_gram_first_last_word_match = TRUE,
  grams.add_only_if_name_new = FALSE,
  grams.add_only_if_specific = FALSE,
  types_rm = c("route", "road", "toilet", "political", "locality", "neighborhood",
    "area", "section of populated place"),
  types_rm.except_with_type = c("flyover", "round about", "roundabout"),
  types_rm.except_with_name = c("flyover", "round about", "roundabout"),
  parallel.sep_slash = TRUE,
  parallel.rm_begin = c(tm::stopwords("en"), c("near", "at", "the", "towards", "near")),
  parallel.rm_end = c("bar", "shops", "restaurant", "sports bar", "hotel", "bus station"),
  parallel.word_diff = "default",
  parallel.word_diff_iftype = list(list(words = c("stage", "bus stop", "bus station"),
    type = "transit_station")),
  parallel.rm_begin_iftype = NULL,
  parallel.rm_end_iftype = list(list(words = c("stage", "bus stop", "bus station"), type
    = "transit_station")),
  parallel.word_begin_addtype = NULL,
  parallel.word_end_addtype = list(list(words = c("stage", "bus stop", "bus station"),
    type = "stage")),
  parallel.add_only_if_name_new = FALSE,
  parallel.add_only_if_specific = FALSE,
  rm.contains = c("road", "rd"),
  rm.name_begin = c(tm::stopwords("en"), c("near", "at", "the", "towards", "near")),
  rm.name_end = c("highway", "road", "rd", "way", "ave", "avenue", "street", "st"),
  pos_rm.all = c("ADJ", "ADP", "ADV", "AUX", "CCONJ", "INTJ", "NUM", "PRON", "SCONJ",
    "VERB", "X"),
  pos_rm.except_type = list(pos = c("NOUN", "PROPN"), type = c("bus", "restaurant",
    "bank"), name = ""),
  close_thresh_km = 1,
  quiet = TRUE
)
}
\arguments{
\item{landmarks}{\code{sf} spatial points data.frame of landmarks.}

\item{landmarks.name_var}{Name of variable indicating name of landmark. (Default: \code{"name"}).}

\item{landmarks.type_var}{Name of variable indicating type of landmark. (Default: \code{"type"}).}

\item{grams.min_words}{Minimum number of words in name to make n/skip-grams out of name. (Default: \code{3}).}

\item{grams.max_words}{Maximum number of words in name to make n/skip-grams out of name. Setting a cap helps to reduce spurious landmarks that may come out of really long names. (Default: \code{6}).}

\item{grams.skip_gram_first_last_word_match}{For skip-grams, should first and last word be the same as the original word? (Default: \code{TRUE}).}

\item{grams.add_only_if_name_new}{When creating new landmarks based on n- and skip-grams, only add an additional landmark if the name of the landmark is new; i.e., the name doesn't already exist in the gazetteer. (Default: \code{FALSE}).}

\item{grams.add_only_if_specific}{When creating new landmarks based on n- and skip-grams, only add an additional landmark if the name of the landmark represents a specific location. A specific location is a location where most landmark entries with the same name are close together (within \code{close_thresh_km} kilometers). (Default: \code{FALSE}).}

\item{types_rm}{If landmark has one of these types, remove - unless \code{types_rm.except_with_type} or \code{types_rm.except_with_name} prevents removing. (Default: \code{c("route", "road", "toilet", "political", "locality", "neighborhood", "area", "section of populated place")}).}

\item{types_rm.except_with_type}{Landmark types to always keep. This parameter only becomes relevant in cases where a landmark has more than one type. If a landmark has both a "types_rm" and a "types_always_keep" landmark, this landmark will be kept. (Default: \code{c("flyover", "round about", "roundabout")}).}

\item{types_rm.except_with_name}{Landmark names to always keep. This parameter only becomes relevant in cases where a landmark is one of "types_rm" Here, we keep the landmark if "names_always_keep" is somewhere in the name. For example, if the landmark is a road but has flyover in the name, we may want to keep the landmark as flyovers are small spatial areas. (Default: \code{c("flyover", "round about", "roundabout")}).}

\item{parallel.sep_slash}{If a landmark contains a slash, create new landmarks before and after the slash. (Default: \code{TRUE}).}

\item{parallel.rm_begin}{If a landmark name begins with one of these words, add a landmark that excludes the word. (Default: \code{c(tm::stopwords("en"), c("near","at","the", "towards", "near"))}).}

\item{parallel.rm_end}{If a landmark name ends with one of these words, add a landmark that excludes the word. (Default: \code{c("bar", "shops", "restaurant","sports bar","hotel", "bus station")}).}

\item{parallel.word_diff}{If the landmark includes one of these words, add a landmark that swaps the word for the other word (e.g., "center" with "centre"). By default, uses a set collection of words. Users can also manually specify different word versions. Input should be a \code{data.frame} with the following variables: \code{version_1} (for one spelling of the word) and \code{version_2} (for a second spelling of the word).}

\item{parallel.word_diff_iftype}{If the landmark includes one of these words, add a landmark that swaps the word for the other word (e.g., "bus stop" with "bus station"). Enter a named list of words, with \code{words = c()} and \code{type = c()}. (Default: \code{list(list(words = c("stage", "bus stop",  "bus station"), type = "transit_station"))}).}

\item{parallel.rm_begin_iftype}{If a landmark name begins with one of these words, add a landmark that excludes the word if the landmark is a certain type. (Default: \code{NULL}).}

\item{parallel.rm_end_iftype}{If a landmark name ends with one of these words, add a landmark that excludes the word if the landmark is a certain type. (Default: \code{list(list(words = c("stage", "bus stop",  "bus station"), type = "transit_station"))}).}

\item{parallel.word_begin_addtype}{If the landmark begins with one of these words, add the type. For example, if landmark is "restaurant", this indicates the landmark is a restaurant. Adding the "restaurant" to landmark ensures that the type is reflected. (Default: \code{NULL}).}

\item{parallel.word_end_addtype}{If the landmark ends with one of these words, add the type. For example, if landmark is "X stage", this indicates the landmark is a bus stage. Adding the "stage" to landmark ensures that the type is reflected. (Default: \code{list(list(words = c("stage", "bus stop", "bus station"), type = "stage"))}).}

\item{parallel.add_only_if_name_new}{When creating parallel landmarks using the above parameters, only add an additional landmark if the name of the landmark is new; i.e., the name doesn't already exist in the gazetteer. (Default: \code{FALSE}).}

\item{parallel.add_only_if_specific}{When creating parallel landmarks using the above parameters, only add an additional landmark if the name of the landmark represents a specific location. A specific location is a location where most landmark entries with the same name are close together (within \code{close_thresh_km} kilometers). (Default: \code{FALSE}).}

\item{rm.contains}{Remove the landmark if it contains one of these words. Implemented after N/skip-grams and parallel landmarks are added. (Default: \code{c("road", "rd")}).}

\item{rm.name_begin}{Remove the landmark if it begins with one of these words. Implemented after N/skip-grams and parallel landmarks are added. (Default: \code{c(tm::stopwords("en"), c("near","at","the", "towards", "near"))}).}

\item{rm.name_end}{Remove the landmark if it ends with one of these words. Implemented after N/skip-grams and parallel landmarks are added. (Default: \code{c("highway", "road", "rd", "way", "ave", "avenue", "street", "st")}).}

\item{pos_rm.all}{Part-of-speech categories to remove. Part-of-speech determined by Spacy. (Default: \code{c("ADJ", "ADP", "ADV", "AUX", "CCONJ", "INTJ", "NUM", "PRON", "SCONJ", "VERB", "X")}).}

\item{pos_rm.except_type}{When specify part-of-speech categories to remove in \code{pos_rm.all}, when to override \code{pos_rm.all} and keep the word. Names list with: (1) \code{pos} (if the word is also another type of part-of-speech); (2) \code{type} (if the word is also a certain type of place); and (3) \code{name} (if the word includes certain text). Example: \code{list(pos = c("NOUN", "PROPN"), type = c("bus", "restaurant", "bank"), name = c("parliament"))}. (Default: \code{list(pos = c("NOUN", "PROPN"), type = c("bus", "restaurant", "bank"), name = "")}).}

\item{close_thresh_km}{When to consider locations close together. Used when determining if a landmark name with multiple locations are specific (close together) or general (far apart). (Default: \code{1}).}

\item{quiet}{Print progress of function. (Default: \code{TRUE}).}
}
\value{
\code{sf} spatial point data.frame of landmarks.
}
\description{
Augments Landmark Gazetteer
}
\examples{
\donttest{
library(ulex)
library(spacyr)
spacy_install()

lm_sf <- data.frame(name = c("white house",
                             "the world bank group",
                             "the george washington university"),
                    lat = c(38.897778,
                            38.89935,
                            38.9007),
                    lon = c(-77.036389,
                            -77.04275,
                            -77.0508),
                    type = c("building", "building", "building")) |>
sf::st_as_sf(coords = c("lon", "lat"),
         crs = 4326)

lm_aug_sf <- augment_gazetteer(lm_sf)
}
}
