% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{ukb_centre}
\alias{ukb_centre}
\title{Inserts UKB centre names into data}
\usage{
ukb_centre(data, centre.var = "^uk_biobank_assessment_centre.*0_0")
}
\arguments{
\item{data}{A UKB dataset created with \code{\link{ukb_df}}.}

\item{centre.var}{The UKB column containing numerically coded assessment centre. The default is a regular expression \code{"^uk_biobank_assessment_centre.*0_0"}.}
}
\value{
A dataframe with an additional column \code{ukb_centre} - UKB assessment centre names
}
\description{
Inserts a column with centre name, \code{ukb_centre}, into the supplied data.frame. Useful if your UKB centre variable \code{uk_biobank_assessment_centre_0_0} has not been populated with named levels.
}
