% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_count}
\alias{txt_count}
\title{Count the number of times a pattern is occurring in text}
\usage{
txt_count(x, pattern, ...)
}
\arguments{
\item{x}{a character vector with text}

\item{pattern}{a text pattern which might be contained in \code{x}}

\item{...}{other arguments, passed on to \code{\link{gregexpr}}}
}
\value{
an integer vector of the same length as \code{x} indicating how many times the pattern is occurring in \code{x}
}
\description{
Count the number of times a pattern is occurring in text. 
Pattern counting is performed by executing a regular expression using \code{\link{gregexpr}} and 
checking how many times the regular expression occurs.
}
\examples{
x <- c("abracadabra", "ababcdab")
txt_count(x, pattern = "ab")
txt_count(x, pattern = "AB", ignore.case = TRUE)
txt_count(x, pattern = "AB", ignore.case = FALSE)
}
