% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_classify.R
\name{predict_rgb}
\alias{predict_rgb}
\title{classify images using raster predict}
\usage{
predict_rgb(imageFiles = NULL, model = NULL, inPrefix = "index_",
  outPrefix = "classified_", bandNames = NULL)
}
\arguments{
\item{imageFiles}{raster*. imagestack for classification purposes must contain the required bands as needed by the model.}

\item{model}{model. classification model}

\item{inPrefix}{character. in frefix  string}

\item{outPrefix}{character. out prefix string}

\item{bandNames}{character. band names}
}
\description{
classify images using raster predict
}
\examples{
\dontrun{
##- required packages
require(uavRst)
require(link2GI)

##- project folder
projRootDir<-tempdir()

##-create subfolders pls notice the pathes are exported as global variables
paths<-link2GI::initProj(projRootDir = projRootDir,
                        projFolders = c("data/","data/ref/","output/","run/","las/"),
                        global = TRUE,
                        path_prefix = "path_")
setwd(path_run)
unlink(paste0(path_run,"*"), force = TRUE)

##- get the tutorial data
utils::download.file("https://github.com/gisma/gismaData/raw/master/uavRst/data/ffs.zip",
paste0(path_run,"ffs.zip"))
unzip(zipfile =  paste0(path_run,"ffs.zip"), exdir = ".")

##- assign tutorial data
imageFile <- paste0(path_run,"predict.tif")
load(paste0(path_run,"tutorialbandNames.RData"))
tutorialModel<-readRDS(file = paste0(path_run,"tutorialmodel.rds"))

##- start the  prediction taking the non optimized model
##- please note the output is saved in the subdirectory path_output
predict_rgb(imageFiles=imageFile,
            model = tutorialModel[[1]],
            bandNames = bandNames)

##- visualise the classification
raster::plot(raster::raster(paste0(path_output,"classified_predict.tif")))
##+}
}
