% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMARconstructor.R
\name{add_data}
\alias{add_data}
\title{Add data to object of class 'gsmar' defining a GMAR, StMAR or G-StMAR model}
\usage{
add_data(data, gsmar, calc_qresiduals = TRUE, calc_std_errors = FALSE)
}
\arguments{
\item{data}{a numeric vector class \code{'ts'} object containing the data. \code{NA} values are not supported.}

\item{gsmar}{object of class \code{'gsmar'}, generated by function \code{fitGSMAR()} or \code{GSMAR()}.}

\item{calc_qresiduals}{should quantile residuals be calculated? Default is \code{TRUE} if the model contains data.}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\value{
Returns an object of class 'gsmar' defining the GMAR, StMAR or G-StMAR model with the data added to the model.
  If the object already contained data, the data will be updated.
}
\description{
\code{add_data} adds or updates data to object of class '\code{gsmar}' that defines a GMAR, StMAR or G-StMAR
 model based on the given object. Also calculates mixing weights and quantile residuals accordingly.
}
\examples{
# GMAR model without data
params13 <- c(1.4, 0.88, 0.26, 2.46, 0.82, 0.74, 5.0, 0.68, 5.2, 0.72, 0.2)
gmar13 <- GSMAR(p=1, M=3, params=params13, model="GMAR")
gmar13

# Add data to the model
gmar13 <- add_data(data=VIX, gmar13)
gmar13
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item There are currently no published references for G-StMAR model, but it's a straight forward generalization with
           theoretical properties similar to GMAR and StMAR models.
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{iterate_more}}, \code{\link{get_gradient}},
 \code{\link{get_regime_means}}
}
