% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{SpectralReference-class}
\alias{SpectralReference-class}
\title{Spectral Reference Class}
\value{
A S4 object of class "SpectralReference".
}
\description{
I made this class to hold spectral libraries. This libraries can be used to match a know spectrum with a pixel reading. \code{\link[=SpectralReference-class]{SpectralReference}} objects are used by several functions in the package, at all analysis stages (i.e. preprocessing, processing, and summarizing/plotting). You can see an example in the data \code{\link{primpke}} (you can load it by calling data("primpke")). The format includes character/integer vectors to hold the names of the polymers, cluster IDs, and cluster names, all of which should correspond to one another. It also hold a matrix with the spectra of each polymer, with rows matching the vectors provided and a fourth vector holding the wavelengts (that should be equal to the matrix cols).

The example provided in the package was taken form Primpke, S., Wirth, M., Lorenz, C., Gerdts, G. 2018. Reference database design for the automated analysis of microplastic samples based on Fourier transform infrared (FTIR) spectroscopy. Analytical and Bioanalytical Chemistry 410: 5131-5141. You might access to the article here \url{https://doi.org/10.1007/s00216-018-1156-x}.

If you have reference data that was taken considering a different range of wavenumbers, you should resample it first for the wavenumbers to match.
}
\section{Slots}{

\describe{
\item{\code{substances}}{A character vector identifying by name the polymers whose spectrum is provided in Spectra. The order of the elements should be consistent with clusterlist, clusternames and Spectral rows. Along the same lines, the object expects length(substances) == nrow(Spectra).}

\item{\code{clusterlist}}{If the polymers are aggregated in clusters this slot should hold an integer vector with the correspondent cluster for each polymer individuated in substances. If you don't want to use clusters or you don't have clusters for your polymers/library you can place a sequence of integers from 1:nrow(Spectra) (e.g. by calling seq_along(substances)) in this slot.}

\item{\code{clusternames}}{Character vector holding reference names for each cluster, sorted according to clusterlist. In other words, if you want to name cluster 1L "polystyrene" the first position in clusternames should be equal to "polystyrene". If you don't want to use clusters or you don't have clusters for your polymers/library you can duplicate substances. The program expects that the length of the clusternames vector equals the length of unique elements in clusterlist.}

\item{\code{Spectra}}{A matrix holding row-wise the spectrum of each substance. Each row should correspond to the spectrum of one substance. In the same lines, columns should hold recorded measures for each wavenumber. The program expects that the length of the substance vector equals the number of rows of Spectra and that the number of colums of Spectra equals the length of the wavenumbers vector.}

\item{\code{wavenumbers}}{A numeric vector with the wavenumbers.}
}}

\examples{
data("primpke")
}
