% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/documentation.R,
%   R/two_samples.R
\name{ad_stat}
\alias{ad_stat}
\alias{ad_test}
\title{Anderson-Darling Test}
\usage{
ad_stat(a, b, power = 2)

ad_test(a, b, nboots = 2000, p = default.p)
}
\arguments{
\item{a}{a vector of numbers}

\item{b}{a vector of numbers}

\item{power}{power to raise test stat to}

\item{nboots}{Number of bootstrap iterations}

\item{p}{power to raise test stat to}
}
\value{
Output is a length 2 Vector with test stat and p-value in that order. That vector has 3 attributes -- the sample sizes of each sample, and the number of bootstraps performed for the pvalue.
}
\description{
Anderson-Darling Test
}
\details{
The AD test compares two ECDFs by looking at the weighted sum of the squared differences between them -- evaluated at each point in the joint sample. The weights are determined by the variance of the joint ECDF at that point. Formally -- if E is the ECDF of sample 1, F is the ECDF of sample 2, and G is the ECDF of the joint sample then CVM = SUM_(x in k) (E(x)-F(x))^2/(G(x)*(1-G(x))) where k is the joint sample. The test p-value is calculated by randomly resampling two samples of the same size using the combined sample. Intuitively the AD test improves on the CVM test by giving lower weight to noisy observations.
}
\section{Functions}{
\itemize{
\item \code{ad_stat}: Anderson-Darling Test statistic

\item \code{ad_test}: Permutation based two sample Anderson-Darling test
}}

\examples{
vec1 = rnorm(20)
vec2 = rnorm(20,4)
ad_test(vec1,vec2)
}
